/*
 * Decompiled with CFR 0.152.
 */
package scientific;

import com.nokia.mid.appl.calc2.Local;
import common.control.DisplayManager;
import common.util.Tools;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import scientific.Symbol;

public final class Number
extends Symbol {
    public Number(String value) {
        super(-1);
        this.value = value;
        if (value.equals(".")) {
            this.value = "0" + value;
        }
    }

    public double calculate(boolean isDegrees) {
        return Tools.getInstance().parseDouble(this.value);
    }

    public void setLeftChild(Symbol leftChild) {
        this.leftChild = null;
    }

    public Symbol getLeftChild() {
        return null;
    }

    public void setRightChild(Symbol rightChild) {
        this.rightChild = null;
    }

    public Symbol getRightChild() {
        return null;
    }

    public void addDigit(String digit) {
        if (digit == null || this.value == null) {
            return;
        }
        if (this.value.length() >= 15) {
            return;
        }
        if (digit.equals(".") && !this.canAddDecimalSeparator()) {
            return;
        }
        if ((this.value.equals("0") || this.value.equals("-0")) && (digit.equals("0") || digit.equals("-0"))) {
            return;
        }
        if ((this.value.equals("0") || this.value.equals("-0")) && (digit.equals("1") || digit.equals("2") || digit.equals("3") || digit.equals("4") || digit.equals("5") || digit.equals("6") || digit.equals("7") || digit.equals("8") || digit.equals("9"))) {
            this.value = digit;
            return;
        }
        if (digit.equals("\u03c0") || this.value.equals("\u03c0")) {
            return;
        }
        this.value = this.value + digit;
    }

    public boolean removeLastDigit() {
        if (this.value == null || this.value.length() == 0) {
            return true;
        }
        this.value = !this.isNegative() ? this.value.substring(0, this.value.length() - 1) : (this.value.length() > 2 ? this.value.substring(0, this.value.length() - 1) : "");
        return this.value.length() == 0;
    }

    public boolean changeSign() {
        if (this.value == null) {
            return false;
        }
        if (this.isNegative()) {
            this.value = this.value.substring(1);
        } else if (this.value.length() < 15) {
            this.value = "-" + this.value;
        } else {
            String outOfRange = Local.getText(11, new String[]{String.valueOf(15)});
            Alert alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
            DisplayManager.getInstance().push(alert);
            return false;
        }
        return true;
    }

    public void calcPercentage() {
        if (this.value == null || this.value.length() == 0 || this.value.equals("0") || this.value.equals("0.")) {
            return;
        }
        double doubleValue = Tools.getInstance().parseDouble(this.value) / 100.0;
        this.value = Tools.getInstance().doubleToStringRounded(doubleValue, 15);
    }

    public boolean isNegative() {
        return this.value.indexOf("-".charAt(0)) >= 0;
    }

    public boolean isZero() {
        double doubleValue = Tools.getInstance().parseDouble(this.value);
        return doubleValue == 0.0;
    }

    public boolean canAddDecimalSeparator() {
        if (this.value.length() > 13) {
            return false;
        }
        return this.value.indexOf(".") < 0;
    }
}

